/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.properties.Property;

public class PropertyMap {
    private final Map<Property, Comparable> properties;

    private PropertyMap(Map<Property, Comparable> properties) {
        this.properties = properties;
    }

    public <T extends Comparable<T>> PropertyMap setProperty(Property<T> property, T value) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalArgumentException("Cannot set property that is not already in the map: " + property.m_61708_());
        }
        HashMap<Property, Comparable> props = new HashMap<Property, Comparable>(this.properties);
        props.put(property, value);
        return new PropertyMap(props);
    }

    public <T extends Comparable<T>> T getProperty(Property<T> property) {
        return (T)this.properties.get(property);
    }

    public Set<Property<?>> getProperties() {
        return this.properties.keySet();
    }

    public Map<Property, Comparable> getValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyMap that = (PropertyMap)o;
        return this.properties.equals(that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.properties.size());
        this.properties.forEach((p, v) -> {
            buf.m_130070_(p.m_61708_());
            buf.m_130070_(p.m_6940_(v));
        });
    }

    public PropertyMap deserialize(FriendlyByteBuf buf) {
        return this.deserialize(PartialDeserialization.deserialize(buf));
    }

    public PropertyMap deserialize(PartialDeserialization data) {
        PropertyMap map = this;
        Map props = this.properties.keySet().stream().collect(Collectors.toMap(Property::m_61708_, Function.identity()));
        for (Map.Entry<String, String> entry : data.properties.entrySet()) {
            Property prop = (Property)props.get(entry.getKey());
            if (prop == null) {
                throw new IllegalStateException("Cannot deserialize property map.");
            }
            Optional val = prop.m_6215_(entry.getValue());
            if (val.isEmpty()) {
                throw new IllegalStateException("Cannot deserialize property map.");
            }
            map = map.setProperty(prop, (Comparable)val.get());
        }
        return map;
    }

    public static class PartialDeserialization {
        private final Map<String, String> properties;

        private PartialDeserialization(Map<String, String> properties) {
            this.properties = properties;
        }

        public static PartialDeserialization deserialize(FriendlyByteBuf buf) {
            HashMap<String, String> map = new HashMap<String, String>();
            int amt = buf.readInt();
            for (int i = 0; i < amt; ++i) {
                String prop = buf.m_130277_();
                String val = buf.m_130277_();
                map.put(prop, val);
            }
            return new PartialDeserialization(map);
        }
    }

    public static class Builder {
        private final Map<Property, Comparable> properties = new HashMap<Property, Comparable>();

        public Builder add(Property ... props) {
            for (Property prop : props) {
                this.properties.put(prop, (Comparable)prop.m_6908_().iterator().next());
            }
            return this;
        }

        public <T extends Comparable<T>> Builder add(Property<T> property, T value) {
            this.properties.put(property, value);
            return this;
        }

        public boolean isEmpty() {
            return this.properties.isEmpty();
        }

        public PropertyMap build() {
            return new PropertyMap((Map<Property, Comparable>)ImmutableMap.copyOf(this.properties));
        }
    }
}

